/******************************************************************************/
class TeleportObject : BaseEvent
{
public:
            TeleportObject();
   virtual ~TeleportObject();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();

   Vec m_Destination, m_Origin;
   UID m_ObjID;
   Game.Obj* m_Obj;
   bool m_LockHeight; // If you want to move the object on a horizontal plane. 
};
/******************************************************************************/
TeleportObject::TeleportObject() : BaseEvent(), m_Destination(0), m_Origin(0), m_LockHeight(false), m_Obj(null)                    
{
   
}
TeleportObject::~TeleportObject()
{
   
}
/******************************************************************************/
void TeleportObject::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("Destination")) m_Destination = p.asVec();
   if(Param *p = obj.findParam("ObjectID"))    m_ObjID       = p.asID();
   if(Param *p = obj.findParam("LockHeight"))  m_LockHeight  = p.asBool();
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void TeleportObject::AfterCreate()
{
   Memc<Game.Obj*> objs;
   Game.World.objGet(objs, Ball(10000, matrix().pos));
   
   REPA(objs)   
      if(objs[i].id() == m_ObjID)
         m_Obj = objs[i];
         
   DEBUG_ASSERT(m_Obj, "Object not found in scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void TeleportObject::CallTriggeredAction()
{
   // Store the current position, and move the object
   m_Origin = m_Obj.pos();

   if(m_LockHeight) m_Destination.y = m_Origin.y;

   m_Obj.pos(m_Destination);
}

// This method is called when the duration of the event has been reached
void TeleportObject::StopTriggeredAction()
{
   // Move the object back to its original position
   if(m_Obj) m_Obj.pos(m_Origin);
}
/******************************************************************************/